/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.ProjectTemplateNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectTemplatesNode
extends BaseNode<Property> {
    private static final Image PROJECT_TEMPLATES_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private ProjectTemplateNode[] projectTemplates;

    ProjectTemplatesNode(BundleElement bundle) {
        this(bundle.getProjectTemplates());
    }

    ProjectTemplatesNode(List<ProjectTemplateElement> elements) {
        ArrayList<ProjectTemplateNode> templates = new ArrayList<ProjectTemplateNode>();
        if (elements != null) {
            for (ProjectTemplateElement template : elements) {
                templates.add(new ProjectTemplateNode(template));
            }
        }
        this.projectTemplates = templates.toArray(new ProjectTemplateNode[templates.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.projectTemplates;
    }

    @Override
    public Image getImage() {
        return PROJECT_TEMPLATES_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.ProjectTemplatesNode_Projects_Templates;
    }

    @Override
    public boolean hasChildren() {
        return this.projectTemplates.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<ProjectTemplatesNode>
    {
        COUNT(Messages.ProjectTemplatesNode_Project_Templates_Count){

            public Object getPropertyValue(ProjectTemplatesNode node) {
                return node.projectTemplates.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(ProjectTemplatesNode node) {
            return null;
        }
    }
}

